#include "data.h"
str FONT = "URWGothic-Book_edited.ttf";
BlockType * Data_BlockWood;
BlockType * Data_BlockWood2;
BlockType * Data_BlockGrass;
BlockType * Data_BlockGrassVar1;
BlockType * Data_BlockGrassVar2;
BlockType * Data_BlockExit;
BlockType * Data_BlockExitR;
BlockType * Data_BlockExitU;
BlockType * Data_BlockExitD;
BlockType * Data_IsoBoulder;
BlockType * Data_IsoPlankV;
BlockType * Data_IsoPlank;
BlockType * Data_Herbalist;
BlockType * Data_Pyramidtree;
BlockType * Data_PyramidtreeCandy;
BlockType * Data_Chameleon;
BlockType * Data_Elephant;
BlockType * Data_Skunk;
BlockType * Data_IridescentBubble;
LandSound * Data_step;
LandSound * Data_push;
LandSound * Data_off;
LandSound * Data_on;
LandSound * Data_uhg;
LandSound * Data_oh_no;
LandSound * Data_teleport;
LandSound * Data_glass;
LandSound * Data_metal;
LandSound * Data_ignition;
LandSound * Data_pickup;
static BlockType* render_load(char const * name, float x, float y, float z, bool dynamic, bool lift, bool transparent, bool fixed, int frames, bool animated, str suffix);
static LandSound* render_loads(char const * name);
void data_load_blocktypes(void) {
    block_types = land_array_new();
    Data_BlockWood = render_load("block-wood", 1, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockWood);
    Data_BlockWood2 = render_load("block-wood2", 1, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockWood2);
    Data_BlockGrass = render_load("block-grass", 1, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockGrass);
    Data_BlockGrassVar1 = render_load("block-grass_var1", 1, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockGrassVar1);
    Data_BlockGrassVar2 = render_load("block-grass_var2", 1, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockGrassVar2);
    Data_BlockExit = render_load("block-exit", 0.5, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockExit);
    Data_BlockExitR = render_load("block-exit_r", 0.5, 0.25, 1, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockExitR);
    Data_BlockExitU = render_load("block-exit_u", 1, 0.25, 0.5, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockExitU);
    Data_BlockExitD = render_load("block-exit_d", 1, 0.25, 0.5, 0, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_BlockExitD);
    Data_IsoBoulder = render_load("iso-boulder", 1.1, 1.5, 1.1, 1, 0, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_IsoBoulder);
    Data_IsoPlankV = render_load("iso-plank_v", 1.2, 0.1, 0.5, 1, 1, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_IsoPlankV);
    Data_IsoPlank = render_load("iso-plank", 0.5, 0.1, 1.2, 1, 1, 0, 0, 1, 0, "");
    land_array_add(block_types, Data_IsoPlank);
    Data_Herbalist = render_load("herbalist", 0.75, 1.25, 0.75, 1, 0, 0, 1, 25, 0, "");
    land_array_add(block_types, Data_Herbalist);
    Data_Pyramidtree = render_load("pyramidtree", 0.5, 0.5, 0.5, 1, 0, 0, 0, 35, 0, "");
    land_array_add(block_types, Data_Pyramidtree);
    Data_PyramidtreeCandy = render_load("pyramidtree_candy", 0.5, 0.5, 0.5, 1, 0, 0, 0, 25, 0, "");
    land_array_add(block_types, Data_PyramidtreeCandy);
    Data_Chameleon = render_load("chameleon", 0.5, 0.5, 0.5, 1, 0, 0, 0, 25, 0, "");
    land_array_add(block_types, Data_Chameleon);
    Data_Elephant = render_load("elephant", 1.5, 1.25, 1.5, 1, 0, 0, 0, 25, 0, "_eardown");
    land_array_add(block_types, Data_Elephant);
    Data_Skunk = render_load("skunk", 0.75, 0.75, 0.5, 1, 0, 0, 0, 25, 0, "");
    land_array_add(block_types, Data_Skunk);
    Data_IridescentBubble = render_load("iridescent_bubble", 0.25, 0.25, 0.25, 1, 0, 0, 0, 32, 0, "");
    land_array_add(block_types, Data_IridescentBubble);
    int i = 0;
    {
        LandArrayIterator __iter0__ = LandArrayIterator_first(block_types);
        for (BlockType * bt = LandArrayIterator_item(block_types, &__iter0__); LandArrayIterator_next(block_types, &__iter0__); bt = LandArrayIterator_item(block_types, &__iter0__)) {
            bt->btid = i++;
            print("block type %3d: %s", bt->btid, bt->name);
        }
    }
    Data_Skunk->tick = player_tick;
    Data_Skunk->touch = player_touch;
    Data_Skunk->destroy = player_destroy;
    Data_Skunk->allocate = player_allocate;
    Data_Skunk->post_init = player_init;
    Data_Elephant->tick = player2_tick;
    Data_Elephant->touch = player2_touch;
    Data_Elephant->allocate = player2_allocate;
    Data_Elephant->post_init = player2_init;
    Data_Herbalist->post_init = herbalist_init;
    Data_Herbalist->tick = herbalist_tick;
    Data_IridescentBubble->post_init = bubble_init;
    Data_IridescentBubble->tick = bubble_tick;
    Data_Pyramidtree->post_init = pyramidtree_init;
    Data_Pyramidtree->tick = pyramidtree_tick;
    Data_PyramidtreeCandy->post_init = pyramidtree_init;
    Data_PyramidtreeCandy->tick = pyramidtree_tick;
    Data_Chameleon->tick = chameleon_tick;
    Data_Chameleon->post_init = pyramidtree_init;
}
void data_load(void) {
    Application * a = app();
    Render * r = render_global();
    data_loading_screen();
    land_flip();
    r->music = land_stream_new(2048, 4, 22050, 16, 2);
    load_info();
    play_song();
    if (a->fullscreen) {
        land_display_toggle_fullscreen();
    }
    r->atlas = land_atlas_new("atlas.txt");
    Data_step = render_loads("step");
    Data_push = render_loads("push");
    Data_off = render_loads("off");
    Data_on = render_loads("on");
    Data_uhg = render_loads("uhg");
    Data_oh_no = render_loads("oh no");
    Data_teleport = render_loads("teleport");
    Data_glass = render_loads("glass");
    Data_metal = render_loads("metal");
    Data_ignition = render_loads("ignition");
    Data_pickup = render_loads("pickup");
    data_load_blocktypes();
}
LandImage* data_load_icon(void) {
    return land_image_load("icon.png");
}
static BlockType* render_load(char const * name, float x, float y, float z, bool dynamic, bool lift, bool transparent, bool fixed, int frames, bool animated, str suffix) {
    Render * r = render_global();
    BlockType * bt = NULL;
    float ss = 96;
    bt = blocktype_new(name, ss * x, ss * y, ss * z, block_tick, block_touch, block_destroy, block_allocate, block_post_init);
    bt->dynamic = dynamic;
    bt->lift = lift;
    bt->transparent = transparent;
    bt->fixed = fixed;
    bt->animated = animated || dynamic;
    LandBuffer * b = land_buffer_new();
    land_buffer_cat(b, "out/");
    land_buffer_cat(b, name);
    land_buffer_cat(b, suffix);
    char * path = land_buffer_finish(b);
    print("loading %s", path);
    for (int fi = 1; fi < frames + 1; fi += 1) {
        char s [1024];
        sprintf(s, "%s_%04d.png", path, fi);
        LandImage * pic = land_atlas_image_create(r->atlas, s);
        if (! pic || ! land_image_was_loaded(pic)) {
            print("Could not load %s", s);
            break;
        }
        if (! bt->bitmaps) {
            bt->bitmaps = land_array_new();
        }
        land_array_add(bt->bitmaps, pic);
        int ow, oh;
        land_atlas_image_original_size(r->atlas, s, & ow, & oh);
        land_image_shift(pic, ow / 2.0, oh / 2.0);
    }
    land_free(path);
    return bt;
}
void data_teardown(void) {
    Render * r = render_global();
    blocktype_destroy(Data_BlockWood);
    blocktype_destroy(Data_BlockWood2);
    blocktype_destroy(Data_BlockGrass);
    blocktype_destroy(Data_BlockGrassVar1);
    blocktype_destroy(Data_BlockGrassVar2);
    blocktype_destroy(Data_BlockExit);
    blocktype_destroy(Data_BlockExitR);
    blocktype_destroy(Data_BlockExitU);
    blocktype_destroy(Data_BlockExitD);
    blocktype_destroy(Data_IsoBoulder);
    blocktype_destroy(Data_IsoPlankV);
    blocktype_destroy(Data_IsoPlank);
    blocktype_destroy(Data_Herbalist);
    blocktype_destroy(Data_Pyramidtree);
    blocktype_destroy(Data_PyramidtreeCandy);
    blocktype_destroy(Data_Chameleon);
    blocktype_destroy(Data_Elephant);
    blocktype_destroy(Data_Skunk);
    blocktype_destroy(Data_IridescentBubble);
    land_sound_destroy(Data_step);
    land_sound_destroy(Data_push);
    land_sound_destroy(Data_off);
    land_sound_destroy(Data_on);
    land_sound_destroy(Data_uhg);
    land_sound_destroy(Data_oh_no);
    land_sound_destroy(Data_teleport);
    land_sound_destroy(Data_glass);
    land_sound_destroy(Data_metal);
    land_sound_destroy(Data_ignition);
    land_sound_destroy(Data_pickup);
    if (r->music) {
        land_stream_destroy(r->music);
    }
}
static LandSound* render_loads(char const * name) {
    LandBuffer * b = land_buffer_new();
    land_buffer_cat(b, "audio/");
    land_buffer_cat(b, name);
    land_buffer_cat(b, ".ogg");
    char * fpath = land_buffer_finish(b);
    LandSound * s = land_sound_load(fpath);
    land_free(fpath);
    if (! s) {
        print("Could not load %s", fpath);
    }
    return s;
}
void data_loading_screen(void) {
    Application * a = app();
    land_clear(1, 1, 1, 1);
    land_clear_depth(1);
    land_reset_transform();
    float w = land_display_width();
    float h = land_display_height();
    land_scale(w / 960, w / 960);
    land_text_pos(960 / 2, (h / (w / 960)) / 2 - 10);
    land_font_set(a->medium);
    land_color(0, 0, 0, 1);
    land_print_center("%s", "Loading! Please Wait!");
}
